<#ibiztemplate>
TARGET=PSSYSTEM
</#ibiztemplate>
<#if sys.codeName == 'Sample'>
package ${pub.getPKGCodeName()}.util.annotation;

import ${pub.getPKGCodeName()}.util.service.ValueRuleValidator;

import javax.validation.Constraint;
import javax.validation.Payload;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

@Target({FIELD, METHOD, PARAMETER, ANNOTATION_TYPE, TYPE_USE})
@Retention(RUNTIME)
@Constraint(validatedBy = {ValueRuleValidator.class})
@Documented
public @interface ValueRuleCheck {

    String field();

    String rule();

    String message() default "值规则检查异常!";

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};

    @Target({TYPE_USE})
    @Retention(RUNTIME)
    @Documented
    @interface List {
        ValueRuleCheck[] value();
    }

}
</#if>